/*------------------------------------------------------------------------------*
 * File Name: FilterManager.c													*
 * Creation: Sim 06-28-2007														*
 * Purpose: OriginC Source H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 7/13/2007 HOOK_UP_TO_MENU												*
 *	Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	*
 *	Hong 08/15/07 v8.0682 RESTRAIN_USER_SAVE_FILTER_INTO_SYSTEM_GROUP_FOLDER	*
 *	Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE									*
 *	Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS							*
 *	Hong 09/30/07 v8.0711c GROUP_PATH_CAN_BE_EMPTY								*
 *	Sim 09-30-2007 PROPER_VAR_NAME												*
 *	Sim 10-19-2007 LOCALIZATION													*
 *	Folger 11/02/07 SET_FILTER_MANAGER_INITIAL_SIZE								*
 *	Sim 11-05-2007 CLEAN_LOCALIZATION_CODE										*
 *	Folger 11/14/07 MAP_DIALOG_CHM_HELP											*
 *	Hong 12/12/07 v8.0767 IMPROVE_EDIT_BTN_ENABLE								*
 *	Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include <..\originlab\DialogEx.h>


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <XFBase.h>
#include <..\originlab\fu_utils.h>
#include "FilterManager.h"
#include <..\originlab\INIFileEx.h>///Jake 07/10/07 GET_AND_SET_FILTER_SETTING

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#define STR_DLG_NAME "FilterManager"		//------ Folger 11/02/07 SET_FILTER_MANAGER_INITIAL_SIZE
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
enum
{
	COL_FILENAME = 0,
	COL_SPT_DND,
	COL_FILE_EXT, /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	COL_LOCALIZATION,
};
/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
/* move to sys_utils.h
enum
{
	LOCAL_SYSTEM_FOLDER = 0,
	LOCAL_USER_FOLDER,
	LOCAL_GROUP_FOLDER, 
};
*/
/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
//#define STR_FILTER_SYSTEM_LOCAL		"System"
//#define STR_FILTER_USER_LOCAL		"User"
//#define STR_FILTER_GROUP_LOCAL		"Group" /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
#define STR_FILTER_SYSTEM_LOCAL		_LE("System")
#define STR_FILTER_USER_LOCAL		_LE("User")
#define STR_FILTER_GROUP_LOCAL		_LE("Group")
///---END CLEAN_LOCALIZATION_CODE


int FilterManagerDlg::DoModalEx(HWND hParent)// = NULL) 
{
	InitMsgMap();
	int nRet = ResizeDialog::DoModal(hParent);
	return nRet;
}
virtual int FilterManagerDlg::Create(HWND hParent)// = NULL)
{
	InitMsgMap();
	int nRet = ResizeDialog::Create(hParent);
	Visible=true;		
	return nRet;
}
	
BOOL FilterManagerDlg::OnInitDialog()
{
	ResizeDialog::OnInitDialog(IDC_FILTER_LIST);
	initList();
	enableButton(IDC_APPLY, false); ///---Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE	
	enableButton(IDC_FILTER_EDIT, false); /// Hong 12/12/07 v8.0767 IMPROVE_EDIT_BTN_ENABLE

	return true;
}
BOOL FilterManagerDlg::OnDlgResize(int nType, int cx, int cy)
{
	vector<uint> nBtns = {IDCANCEL, IDC_APPLY, IDC_FILTER_EDIT};
	ArrangeMainItemAndControls(nBtns, IDC_FILTER_LIST, NULL, false);
	
	return true;
}
//------ Folger 11/02/07 SET_FILTER_MANAGER_INITIAL_SIZE
BOOL FilterManagerDlg::OnRestoreSize(DWORD dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;

	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
			
	pSz->top = -1;
	pSz->left = - 1;
	pSz->width = 650;
	pSz->height = 430;
	return TRUE;
}
//------ End SET_FILTER_MANAGER_INITIAL_SIZE
BOOL FilterManagerDlg::OnCancel()
{
	return true;
}

BOOL FilterManagerDlg::OnEdit(Control cntrl)
{
	int nSel = m_list.GetSelectedRow();
	string strFilterName = m_list.GetCell(nSel, COL_FILENAME);
	int nLocalization = _get_num_localization(m_list.GetCell(nSel, COL_LOCALIZATION));
	
	string strFullFilterName;
	///Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
	//strFullFilterName = _get_filter_path(nLocalization) + GetFileName(strFilterName, TRUE) + ".oif";
	strFullFilterName = fu_get_filter_path(nLocalization) + GetFileName(strFilterName, TRUE) + ".oif";
	///end SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
	
	Tree trFilter;
	if ( !fuLoad(trFilter, strFullFilterName) )
		return error_report(_L("Failed to load filter file!"));
	
	XFBase xf("iwfilter");
	
	if (!xf)
		return error_report(_L("Failed to iwfilter xfuction!"));
	
	xf.SetArg("fname", strFullFilterName); /// Hong 08/15/07 v8.0682 RESTRAIN_USER_SAVE_FILTER_INTO_SYSTEM_GROUP_FOLDER
	///---Sim 09-30-2007 PROPER_VAR_NAME
	//xf.SetArg("filter", trFilter);
	xf.SetArg("ifilter", trFilter);
	///---END PROPER_VAR_NAME
	
	int nErr;
	xf.ExecuteLabTalk(NULL, NULL, NULL, 0, &nErr, LTXF_SHOW_DIALOG);
	
	return true;
}
BOOL FilterManagerDlg::OnApply(Control cntrl)
{
	vector<string> vsFilter;
	vector<int>	viLocalization;
	vector<bool> vbSupportDragDrop;
	
	int nSize;
	int ii;
	vector<string> vsVals;
	
	int nRowOffset = m_list.GetRowOffset(); // has 1 row header, data is from second row
	
	// name
	m_list.GetColValues(COL_FILENAME, vsVals, nRowOffset);
	vsFilter = vsVals;
	
	// folder
	m_list.GetColValues(COL_LOCALIZATION, vsVals, nRowOffset);
	nSize = vsVals.GetSize();
	viLocalization.SetSize(nSize);
	for ( ii = 0; ii < nSize; ii++ )
	{
		viLocalization[ii] = _get_num_localization(vsVals[ii]);
	}
	
	// drag & drop setting
	m_list.GetColValues(COL_SPT_DND, vsVals, nRowOffset);
	nSize = vsVals.GetSize();
	vbSupportDragDrop.SetSize(nSize);
	for ( ii = 0; ii < nSize; ii++ )
	{
		vbSupportDragDrop[ii] = ("1" == vsVals[ii]) ? true : false;
	}

	// save setting to ini file
	nSize = vsFilter.GetSize();
	for ( ii = 0; ii < nSize; ii++ )
	{
		//set_filter_setting(GetFileName(vsFilter[ii], TRUE), vbSupportDragDrop[ii], (LOCAL_SYSTEM_FOLDER == viLocalization[ii]), FILTER_SETTING_DRAG_AND_DROG);
		set_filter_setting(GetFileName(vsFilter[ii], TRUE), vbSupportDragDrop[ii], viLocalization[ii]);/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	}
	enableButton(IDC_APPLY, false); ///---Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE
	return true;
}
void FilterManagerDlg::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{
	enableButton(IDC_APPLY, true); ///---Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE
}

/// Hong 12/12/07 v8.0767 IMPROVE_EDIT_BTN_ENABLE
void FilterManagerDlg::OnSelChange(Control control)
{
	int nSel = m_list.GetSelectedRow();
	string strFilterName = m_list.GetCell(nSel, COL_FILENAME);
	
	enableButton(IDC_FILTER_EDIT, !strFilterName.IsEmpty());
}
/// end IMPROVE_EDIT_BTN_ENABLE

//------ Folger 11/14/07 MAP_DIALOG_CHM_HELP
//BOOL FilterManagerDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
//{
	//nHelpID = IDD_FILTER_MANAGER_DLG;
	//return true;
//}
//------ End MAP_DIALOG_CHM_HELP
void FilterManagerDlg::initList()
{
	m_list.Init(IDC_FILTER_LIST, *this);
	//m_list.SetupRowsCols(1, 0, -1, 3);
	m_list.SetupRowsCols(1, 0, -1, 4); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	
	///---Sim 10-19-2007 LOCALIZATION
	/*
	m_list.SetColHeading(COL_FILENAME, "Filter");
	m_list.SetColHeading(COL_LOCALIZATION, "Folder");
	m_list.SetColHeading(COL_FILE_EXT, "File Extensions"); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	m_list.SetColHeading(COL_SPT_DND, "Support Drag&Drop");
	*/
	m_list.SetColHeading(COL_FILENAME, _L("Filter"));
	m_list.SetColHeading(COL_LOCALIZATION, _L("Folder"));
	m_list.SetColHeading(COL_FILE_EXT, _L("File Extensions"));
	m_list.SetColHeading(COL_SPT_DND, _L("Support Drag&Drop"));
	///---END LOCALIZATION
	m_list.SetColDataType(COL_SPT_DND, flexDTBoolean);

	vector<string> vsFilter;
	vector<int>	viLocalization;
	vector<bool> vbSupportDragDrop;
	/// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	//constructFilterList(vsFilter, viLocalization, vbSupportDragDrop);
	vector<string> vsFileExts;
	constructFilterList(vsFilter, viLocalization, vbSupportDragDrop, vsFileExts);
	/// end ADD_FILTER_FILE_EXTENSIONS
	
	// set filter name value
	m_list.SetColValues(COL_FILENAME, vsFilter, 0, true);
	
	// set filter file types
	m_list.SetColValues(COL_FILE_EXT, vsFileExts, 0, true); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	
	// set folder value
	vector<string> vsLocalization;
	int ii;
	for ( ii = 0; ii < viLocalization.GetSize(); ii++ )
	{
		vsLocalization.Add(_get_str_localization(viLocalization[ii]));
	}
	m_list.SetColValues(COL_LOCALIZATION, vsLocalization, 0, true);
	
	// set drag and drop setting value
	vector<string> vsSupportDragDrop;
	for ( ii = 0; ii < vbSupportDragDrop.GetSize(); ii++ )
	{
		vsSupportDragDrop.Add(vbSupportDragDrop[ii]?"1":"0");
	}
	m_list.SetColValues(COL_SPT_DND, vsSupportDragDrop, 0, true);
	
	m_list.ResizeCols();	
}

/// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
//int FilterManagerDlg::constructFilterList(vector<string>& vsFilter, vector<int>& viLocalization, vector<bool>& vbSupportDragDrop)
int FilterManagerDlg::constructFilterList(vector<string>& vsFilter, vector<int>& viLocalization, vector<bool>& vbSupportDragDrop, vector<string>& vsFileExts)
/// end ADD_FILTER_FILE_EXTENSIONS
{
	vsFilter.SetSize(0);
	viLocalization.SetSize(0);
	vbSupportDragDrop.SetSize(0);

	// check user folder
	//_add_filter_list(vsFilter, viLocalization, vbSupportDragDrop, FILTER_LOCATION_USER_FOLDER);
	_add_filter_list(vsFilter, viLocalization, vbSupportDragDrop, vsFileExts, FILTER_LOCATION_USER_FOLDER); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	
	// check exe folder
	//_add_filter_list(vsFilter, viLocalization, vbSupportDragDrop, FILTER_LOCATION_SYSTEM_FOLDER);
	_add_filter_list(vsFilter, viLocalization, vbSupportDragDrop, vsFileExts, FILTER_LOCATION_SYSTEM_FOLDER); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	// check group folder
	//_add_filter_list(vsFilter, viLocalization, vbSupportDragDrop, FILTER_LOCATION_GROUP_FOLDER);
	_add_filter_list(vsFilter, viLocalization, vbSupportDragDrop, vsFileExts, FILTER_LOCATION_GROUP_FOLDER); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	
	return vsFilter.GetSize();
}
///---Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE
void FilterManagerDlg::enableButton(uint nBtnID, bool bEnable)
{
	Control cBtn = GetItem(nBtnID);
	cBtn.Enable = bEnable;
}
///---END IMPROVE_APPLY_BUTTON_ENABLE
	
/// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
//static bool _add_filter_list(vector<string>& vsFilter, vector<int>& vLocalization, vector<bool>& vbSupportDragDrop, int nLocalization = FILTER_LOCATION_SYSTEM_FOLDER)
static bool _add_filter_list(vector<string>& vsFilter, vector<int>& vLocalization, vector<bool>& vbSupportDragDrop, vector<string>& vsFileExts, int nLocalization = FILTER_LOCATION_SYSTEM_FOLDER)
/// end ADD_FILTER_FILE_EXTENSIONS
{
	string strPath;
	//switch (nLocalization)
	//{
	//case LOCAL_SYSTEM_FOLDER:
		//strPath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
		//break;
	//case LOCAL_USER_FOLDER:
		//strPath.Format("%s%s", GetAppPath(FALSE), FILTERS_FOLDER_NAME);
		//break;
	//}
	///Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
	//strPath = _get_filter_path(nLocalization);
	strPath = fu_get_filter_path(nLocalization);
	///end SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
	if ( strPath.IsEmpty() )
		return false;
	
	// search all filter file in special folder
	string strFilterFileNames;
	GetFilenamesInFolder(strFilterFileNames, strPath, IMPORT_FILTER_EXTENSION_WILD, FALSE);
	
	vector<string> vsFiltersInFolder;
	strFilterFileNames.GetTokens(vsFiltersInFolder, '|');
	
	// load setting from ini file
	vector<int> vLocalizationInFolder;
	vector<bool> vbSupportDragDropInFolder;
	vector<string> vsFileExtsInFolder; /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	
	int nSize = vsFiltersInFolder.GetSize();
	vLocalizationInFolder.SetSize(nSize);
	vbSupportDragDropInFolder.SetSize(nSize);
	vsFileExtsInFolder.SetSize(nSize); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	for ( int ii = 0; ii < nSize; ii++ )
	{
		//bool bSupportDragAndDrop = true;
		//get_filter_setting(GetFileName(vsFiltersInFolder[ii], TRUE), bSupportDragAndDrop, (LOCAL_SYSTEM_FOLDER == nLocalization), FILTER_SETTING_DRAG_AND_DROG);
		bool bSupportDragAndDrop;
		//bSupportDragAndDrop = is_drag_n_drop_supported(GetFileName(vsFiltersInFolder[ii], TRUE), (LOCAL_SYSTEM_FOLDER == nLocalization));
		bSupportDragAndDrop = is_drag_n_drop_supported(GetFileName(vsFiltersInFolder[ii], TRUE), nLocalization); /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
		
		vsFiltersInFolder[ii] = GetFileName(vsFiltersInFolder[ii], TRUE);
		vLocalizationInFolder[ii] = nLocalization;
		vbSupportDragDropInFolder[ii] = bSupportDragAndDrop;
		/// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
		string strFileExts;
		Tree trFilter;
		if ( fuLoad(trFilter, vsFiltersInFolder[ii]) )
		{
			strFileExts = fuGetApplicability(trFilter);			
		}
		vsFileExtsInFolder[ii] = strFileExts;		
		/// end ADD_FILTER_FILE_EXTENSIONS
	}
	
	vsFilter.Append(vsFiltersInFolder);	
	vLocalization.Append(vLocalizationInFolder);	
	vbSupportDragDrop.Append(vbSupportDragDropInFolder);
	vsFileExts.Append(vsFileExtsInFolder); /// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	
	return true;
}
///Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
/* move to fu_utils.h 
static string _get_filter_path(int nLocalization = FILTER_LOCATION_SYSTEM_FOLDER)
{
	string strPath;
	switch (nLocalization)
	{
	case FILTER_LOCATION_SYSTEM_FOLDER:
		strPath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
		break;
	case FILTER_LOCATION_USER_FOLDER:
		strPath.Format("%s%s", GetAppPath(FALSE), FILTERS_FOLDER_NAME);
		break;
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	case FILTER_LOCATION_GROUP_FOLDER:
		/// Hong 09/30/07 v8.0711c GROUP_PATH_CAN_BE_EMPTY
		//strPath.Format("%s%s", okutil_get_origin_path(ORIGIN_PATH_GROUP), FILTERS_FOLDER_NAME);
		strPath = okutil_get_origin_path(ORIGIN_PATH_GROUP);
		if ( !strPath.IsEmpty() )		
			strPath.Format("%s%s", strPath, FILTERS_FOLDER_NAME);
		/// end GROUP_PATH_CAN_BE_EMPTY
		break;
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	}
	
	return strPath;
}
*/
///end SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
static int _get_num_localization(LPCSTR lpcszLocalization)
{
	string strLocalization(lpcszLocalization);
	
	///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
	//if (STR_FILTER_SYSTEM_LOCAL == strLocalization)
	if ( compare_string_localization(strLocalization, STR_FILTER_SYSTEM_LOCAL) )
		return FILTER_LOCATION_SYSTEM_FOLDER;
	
	//if (STR_FILTER_USER_LOCAL == strLocalization)
	if ( compare_string_localization(strLocalization, STR_FILTER_USER_LOCAL) )
		return FILTER_LOCATION_USER_FOLDER;
	
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	//if (STR_FILTER_GROUP_LOCAL == strLocalization)
	if ( compare_string_localization(strLocalization, STR_FILTER_GROUP_LOCAL) )
		return FILTER_LOCATION_GROUP_FOLDER;
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	///---END CLEAN_LOCALIZATION_CODE
	
	ASSERT(FALSE);
	return -1;
}

static string _get_str_localization(int nLocalization)
{
	///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
	switch (nLocalization)
	{
	case FILTER_LOCATION_SYSTEM_FOLDER:
		//return STR_FILTER_SYSTEM_LOCAL;
		return GetLocalized(STR_FILTER_SYSTEM_LOCAL);
	case FILTER_LOCATION_USER_FOLDER:
		//return STR_FILTER_USER_LOCAL;
		return GetLocalized(STR_FILTER_USER_LOCAL);
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	case FILTER_LOCATION_GROUP_FOLDER:
		//return STR_FILTER_GROUP_LOCAL;
		return GetLocalized(STR_FILTER_GROUP_LOCAL);
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	}
	///---END CLEAN_LOCALIZATION_CODE
	return "";
}


//------ CPY 7/13/2007 HOOK_UP_TO_MENU
#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
void FilterManager()
{
	FilterManagerDlg fm;
	fm.DoModalEx();
}
//------
